

#include <math.h>

/*
	Al usar una funcin personalizada se puede generar cualquier
	tipo de onda, que ser usada peridicamente para genera la onda
*/
float *CrearTabla(float fase, int largo, float (*GenTabla)(float))
{
	float *tabla = (float *)calloc(largo, sizeof(float));
	float radian = fase * DOS_PI;
  float incr = DOS_PI / (float)largo;
  int i;

  for(i = 0; i < largo; i++) 
		{
    tabla[i] = GenTabla(radian);
    radian += incr;
		}
  return tabla;
}


/*
	Obtengo el lugar actual en la tabla.
	Esto podra hacerse dentro de la funcin que obtiene el valor actual, como lo hace Di Licia
	pero prefer hacerlo as para mostrar las distintas partes del funcionamiento del programa
*/
void LugarActualTabla(float *lug_actual, float frec, int largo, int frec_mues)
{
	*lug_actual += (frec * ((float)largo / (float)frec_mues));

	while (*lug_actual >= (float)largo) 
		*lug_actual -= (float)largo;
  while (*lug_actual < 0.0)
    *lug_actual += (float)largo;
}


/*
obtiene el valor actual de la onda peridica usando 
una interpolacin definida por el usuario.
*/
float ValorActualOnda(float amp, float *tabla, int tam, float lg_act, float (*Interp)(float *, int, float))
{
	float val_act;
	val_act = amp * Interp(tabla, tam, lg_act);
	return val_act;
}


/*
	Envlovente simple para evitar los clics
*/
float Envolvente(int ataque, int caida, int dur, int lg_act)
{
	float mult = 0.0;
	int com_caida = dur - caida;

	if(lg_act < ataque)
		mult = (float)lg_act / (float)ataque;
	if(lg_act > com_caida)
		mult = (float)(dur - lg_act) / (float)caida;
	if(lg_act >= ataque && lg_act <= com_caida)
		mult = 1.0;
	return mult;
}


/*
	funcin seno para ser usada por CrearTabla
*/
float FuncionSeno(float valor)
{
	return sin(valor);
}


/* 
	Defino una funcin que interpola linealmente entre dos valores
*/
float InterpLineal(float *tabla, int tam, float lg_act)
{
	float val_act;
	int lg_ant, lg_sig;

	lg_ant = (int)lg_act;
	lg_sig = lg_ant + 1;
	while(lg_sig >= tam)
		lg_sig -= tam;

	val_act = (tabla[lg_ant] + ((tabla[lg_sig] - tabla[lg_ant]) * (lg_act - lg_ant)));

	return val_act;
}
