

#define DOS_PI (3.14159265358979323846264338327 * 2.0)    /* 2pi */
#define FREC_MUES 44100                                   /* frecuencia de muestreo usada por defecto */
#define NUM_CANALES 2                                     /* cantidad de canales por defecto */


typedef struct
{
	double min;     /* el valor mnimo del rango */
	double max;     /* el valor mximo del rango */
} RANGO;


typedef struct
{
	double frecuencia;   /* en  Hz */
	double amplitud;     /* entre 0 y 1, al menos por ahora */
	double comienzo;     /* lugar donde comienza el evento, en segundos desde el principio de la obra */
	double duracion;     /* duracin del evento en segundos */ 
	double paneo;
} EVENTO;
 

typedef struct
{
	double durTotal ;   /* duracin total de la obra en segundos */
	RANGO evCom;        /* rango de comienzo de los eventos */
	RANGO evDur;        /* rango de duracin de los eventos */
	RANGO evAmp;        /* amplitud mnima y mxima de generacin */
	RANGO evFrec;       /* frecuencia mnima y mxima de generacin */
	RANGO evPan;        /* paneo por intensidad */
} PARAMETROS;


typedef struct 
{
  int na;                /* nmero de archivo asociado, o -1 si se falla la apertura del archivo */
  int canales;				   /* canales del audio */
  int frec_muestreo;     /* frecuencia de muestreo */
  off_t muestras;        /* muestras en total que tiene el archivo de audio */
  off_t mu_can;          /* se refiere a la cantidad de muestras en cada canal */
  float duracion;        /* la duracin en segundos del archivo de audio */
  int formato;           /* el formato que tiene el archivo de audio */
  int cabecera;          /* el tipo de cabecera que usa el audio */
  char *comentario;      /* el comentario que pueda tener el archivo de audio, de otro modo es NULL */
} DAUDIO;

