
/*
	es.h
	define las funcioens de entrada y salida de pantalla y de audio
*/


/* Crea un rtulo cada vez que se usa textura */
void RotuloDeInicio()
{
	printf("\n   textura: generador de eventos sonoros\n");
	printf("   ver. 1.0, 2006\n");
	printf("   Creado en la EUM, Montevideo, Uruguay\n");
}





/* --------------------------------------------------------------------------------------------- */
/* ENTRADA / SALIDA AUDIO ------------------------------------------------------------------------ */


/* 
	Imprime en la consola informacin del archivo de audio guardados en 'dau'.
	Tambin se le pasa el nombre del archivo para obtener el tipo de la cabecera 
	y el formato del audio, stos datos no estn guardados en la estructura DAUDIO. 
	Por ltmo, se permite pasar un mensaje a ser mostrado junto con los datos como ttulo.

	titulo: es utilizado como un ttulo que se agrega ntes del nombre del archvio de audio.
*/
void ImprDatosDeAudio(char *narch, DAUDIO *dau, char *titulo)
{
	fprintf(stdout, "\n%s: %s:\n\n  F.MUESTREO: \t%d  mues/s\n  CANALES: \t%d\n  DURACION: \t%f  seg\n  MUESTRAS: \t%d\n  MUES/CAN: \t%d\n",
		titulo, narch, dau->frec_muestreo, dau->canales, dau->duracion, dau->muestras, dau->mu_can);

  fprintf(stdout, "  TIPO: \t%s\n  FORMATO: \t%s\n  COMENTARIO: \t%s\n", 
								  mus_header_type_name(mus_sound_header_type(narch)),
									mus_data_format_name(mus_sound_data_format(narch)),
									dau->comentario);
}


/* 
	abre un archivo para salida, o sea que puede ser modificado, usando como
	datos la estructura DAUDIO, que contiene toda la info necesaria, luego imprime 
	sus daots.
*/
void AbrirAudioSalida(char* nombre, DAUDIO *datos)
{
  datos->na = mus_sound_open_output(nombre, datos->frec_muestreo, datos->canales, 
				                            datos->formato, datos->cabecera, datos->comentario);
  if (datos->na != -1)
		printf("\nAudio de salida preparado para ser usado ...");
  else 
		{
    fprintf(stderr, "%s: %s\n", nombre, strerror(errno));
    fprintf(stdout,"\n\n Presione aceptar para terminar el programa ..."); 
    getchar();
		}
}


/* Crea memoria para ser usado por el snd. Toma en cuenta el nmero de canales y
la cantidad de muestras por canal */
mus_sample_t **SndAsignarMemoria(DAUDIO *dau)
{
  mus_sample_t **buf = NULL;
  int i;

	/* CALLOC es una macro creada en sndlib.h para reservar memoria	*/
  buf = (mus_sample_t **)CALLOC(dau->canales, sizeof(int *));
  for(i = 0; i < dau->canales; i++) 
		buf[i] = (mus_sample_t *)CALLOC(dau->mu_can, sizeof(mus_sample_t));

	if(buf != NULL)
		printf("\nBufer de memomria asignada para el audio ...\n\n");

  return buf;
}


/* Libera la memoria creada anteriormente para el snd */
void SndLiberarMemoria(DAUDIO *dau, mus_sample_t **buf)
{
  int i;
		/* Debido a que sta memoria fue creada con CALLOC se usa FREE para liberarla */
  for(i = 0; i < dau->canales; i++) 
		FREE(buf[i]);
  FREE(buf);
}

/* FIN ENTRADA / SALIDA AUDIO ------------------------------------------------------------------------ */
