

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


/* DEFINICIN DE FUNCIONES -----------------------------------------------------------*/

/* 
   devuelve un nmero aleatorio entre min y max es usado por varias 
	 funciones para obtener parmetros como frecuencia y intensidad, etc.
*/
double Aleat(double min, double max)
{
	return (double)(max - min) * (1.0 * rand() / RAND_MAX) + min;
}


double *GenComienzos(double durTotal, RANGO com, int *cant)
{
  double *coms = NULL;
	double *temp = NULL;
	int i = 0;

	*cant = (int)(durTotal / com.min);
	temp = (double *)calloc(*cant, sizeof(double));
	temp[0] = 0.0;
	while(temp[i] < durTotal && i < *cant)
		{
		i++;
		temp[i] = Aleat(temp[i-1] + com.min, temp[i-1] + com.max);
		}
	*cant = i;
	coms = (double *)calloc(*cant, sizeof(double));
	for(i = 0; i < *cant; i++)
		coms[i] = temp[i];
	free(temp);
	return coms;
}


double *GenParametro(RANGO par, int cant)
{
  double *pars;
  int i;
	pars = (double *)calloc(cant, sizeof(double));
  for(i = 0; i < cant; i++)
    pars[i] = Aleat(par.min, par.max);
  return pars;
}


EVENTO *ConstruirObra(PARAMETROS *parms, int *cant)
{
	EVENTO *evs;
	double *coms, *durs, *amps, *frecs, *pans;    
	int i;

	coms = GenComienzos(parms->durTotal, parms->evCom, cant);

	durs = GenParametro(parms->evDur, *cant);
	amps = GenParametro(parms->evAmp, *cant);
	frecs = GenParametro(parms->evFrec, *cant);
	pans = GenParametro(parms->evPan, *cant);

	evs = (EVENTO *)calloc(*cant, sizeof(EVENTO));
  for(i = 0; i < *cant; i++)
		{
    evs[i].comienzo = coms[i];
    evs[i].duracion = durs[i];
		evs[i].amplitud = amps[i];
		evs[i].frecuencia = frecs[i];
		evs[i].paneo = pans[i];
    }

	free(coms);
	free(durs);
	free(amps);
	free(frecs);
	free(pans);
	return evs;
}

/* FIN DEFINICIN DE FUNCIONES ---------------------------------------------------------*/

