



#include "sndlib/io.h"
#include "sndlib/headers.h"
#include "sndlib/sound.h"

#include "gens/defs.h"
#include "gens/es.h"
#include "gens/eventos.h"
#include "gens/audio.h"


void ProcesarEventos(DAUDIO *, EVENTO *, int, mus_sample_t **);
void CopiarNormalizado(float **, mus_sample_t **, DAUDIO *, float);
void CompletarDatosAudio(DAUDIO *, EVENTO *, int);


int main(int argc, char **argv)
{

	/* en el futuro, se llena a partir de los datos del usuario */
	PARAMETROS  pars = {50, {.7, 1.7}, {1.5, 2.5}, {2, 9}, {100, 500}, {0.0, 1.0}}; 
	EVENTO *evs;                           /* una tabla de eventos sonoros */
	int cant;                              /* cantidad de eventos generados */
  mus_sample_t **sbuf;                   /* bufer de salida para el audio */

		/* 
		creo una estructura que ser llenada con datos de la cabecera del audio 
		algunos datos son iniciados a -1 porque no son necesarios todava, y dependen de otros datos
		*/
	DAUDIO au_sal = {-1, NUM_CANALES, FREC_MUES, -1, -1, -1, MUS_BSHORT, MUS_NEXT, "escrito por textura"};

	RotuloDeInicio();                             /* muestro el rotulo de la aplicacin */

	mus_sound_initialize();	                           /* inicializo sndlib */
	AbrirAudioSalida(argv[1], &au_sal);                /* abro el audio de salida */
	if(au_sal.na == -1)                                /* todo bien? */
    return -1;

		/* GENERACIN DE EVENTOS  -----------------------*/
	srand((unsigned)time(NULL));
	evs = ConstruirObra(&pars, &cant);
		/* FIN GENERACIN DE EVENTOS  -------------------*/

		/* termino de llenar los datos de la estructura DAUDIO */
	CompletarDatosAudio(&au_sal, evs, cant);

		/* creo el bufer de audio */
	sbuf = SndAsignarMemoria(&au_sal);

		/* proceso los eventos y los guardo en el audio de salida */
	ProcesarEventos(&au_sal, evs, cant, sbuf);

		/* una vez terminado todo, imprimo la cabecera del audio */
	ImprDatosDeAudio(argv[1], &au_sal, "\nAUDIO DE SALIDA");
	printf("\nCantidad de eventos: %i\n", cant);

	SndLiberarMemoria(&au_sal, sbuf);
  close(au_sal.na);
	free(evs);
	return 0;
}

/*
	Procesa los eventos sonoros generados y guardados en la tabla 'evs'.
	Del audio necesito saber: los canales, las muestras por canal, la frecuencia de muestreo,
	el nmero de archivo, y el formato de la cabecera.
*/
void ProcesarEventos(DAUDIO *sal, EVENTO *evs, int ev_cant, mus_sample_t **sbuf)
{
	int i, j, ev, inicio, final;
	float mues, norm = 0.0, pan;

	float *tabla;
	int largo = 4096;
	float **buf_temp;
	float lg_act = 0.0;
	int dur;

	buf_temp = (float **)calloc(sal->canales, sizeof(float *));
	for(i = 0; i < sal->canales; i++)
		buf_temp[i] = (float *)calloc(sal->mu_can, sizeof(float));

	tabla = CrearTabla(0.0, largo, FuncionSeno);     

	printf("\nUsando una onda sinusoidal para la sintesis con interpolacion lineal ...\n");

	for(i = 0; i < sal->canales; i++)
		{
		for(j = 0; j < ev_cant; j++)
			{
			inicio = evs[j].comienzo * sal->frec_muestreo;
			final = inicio + evs[j].duracion * sal->frec_muestreo;
			dur = final - inicio;
			for(ev = inicio; ev < final; ev++)
				{
				mues = ValorActualOnda(evs[j].amplitud, tabla, largo, lg_act, InterpLineal);
				LugarActualTabla(&lg_act, evs[j].frecuencia, largo, sal->frec_muestreo);

				/* paneo por intensidad */
				if(i == 0)
					pan = evs[j].paneo;
				else
					pan = 1 - evs[j].paneo;
				/* fin paneo por intensidad */

				buf_temp[i][ev] += (mues * pan * Envolvente((int)(dur * .2),(int)(dur * .2), dur, (ev - inicio)));
				if((buf_temp[i][ev] >= 1.0 || buf_temp[i][ev] <= -1.0) && abs(buf_temp[i][ev]) > norm)  /* esto es para normalizar */
					norm = abs(buf_temp[i][ev]);
				}
			}
		}
	CopiarNormalizado(buf_temp, sbuf, sal, norm);   /* normalizo y copio los datos */

	mus_sound_write(sal->na, 0, sal->mu_can - 1, sal->canales, sbuf);
  mus_sound_close_output(sal->na, sal->mu_can * mus_bytes_per_sample(sal->formato));
	free(buf_temp);
	free(tabla);
}

/*
	Hace que todos los valores del bufer estn entre 0 y 1.
*/
void CopiarNormalizado(float **ebuf, mus_sample_t **sbuf, DAUDIO *sal, float norm)
{
	int i, j;

	for(i = 0; i < sal->canales; i++)
		for(j = 0; j < sal->mu_can; j++)
			sbuf[i][j] = MUS_FLOAT_TO_SAMPLE((ebuf[i][j] / (norm + 1.0)));
}

/*
	Completa la estructura de audio
*/
void CompletarDatosAudio(DAUDIO *au, EVENTO *evs, int tam)
{
	/* primero debo encontrar cual es el ltimo valor */
	double temp, ultimo = 0.0;   /* el ltimo lugar en segundos */
	int i;
	for(i = 0; i < tam; i++)
		{
		temp = evs[i].comienzo + evs[i].duracion;
		if(temp > ultimo)
			ultimo = temp;
		}
	au->mu_can =  ultimo * FREC_MUES;
	au->muestras = au->mu_can * au->canales;
	au->duracion = (double)au->mu_can / (float)au->frec_muestreo;
}
